
_Main_Init:

;electronique_interface_midi_012_16f628.mpas,75 :: 		begin
;electronique_interface_midi_012_16f628.mpas,76 :: 		CMCON := 7;            // disable comparators
	MOVLW      7
	MOVWF      CMCON+0
;electronique_interface_midi_012_16f628.mpas,77 :: 		OPTION_REG := 0;       // don't disable pullup
	CLRF       OPTION_REG+0
;electronique_interface_midi_012_16f628.mpas,78 :: 		INTCON.GIE := 0;       // |- enable interrupt later
	BCF        INTCON+0, 7
;electronique_interface_midi_012_16f628.mpas,79 :: 		INTCON.PEIE := 0;      // |
	BCF        INTCON+0, 6
;electronique_interface_midi_012_16f628.mpas,80 :: 		TRISA      := %11100000;
	MOVLW      224
	MOVWF      TRISA+0
;electronique_interface_midi_012_16f628.mpas,81 :: 		TRISB      := %11110010;
	MOVLW      242
	MOVWF      TRISB+0
;electronique_interface_midi_012_16f628.mpas,82 :: 		PORTA      := %00010000;  // clear porta
	MOVLW      16
	MOVWF      PORTA+0
;electronique_interface_midi_012_16f628.mpas,83 :: 		PORTB      := 0;  // clear portb
	CLRF       PORTB+0
;electronique_interface_midi_012_16f628.mpas,84 :: 		T1CON.T1CKPS1 := 1;
	BSF        T1CON+0, 5
;electronique_interface_midi_012_16f628.mpas,87 :: 		TXSTA.SYNC := 0;    // asynchronous mode
	BCF        TXSTA+0, 4
;electronique_interface_midi_012_16f628.mpas,88 :: 		TXSTA.TX9 := 0;     // 8-bits transmission
	BCF        TXSTA+0, 6
;electronique_interface_midi_012_16f628.mpas,89 :: 		TXSTA.TXEN := 1;    // Tx enabled
	BSF        TXSTA+0, 5
;electronique_interface_midi_012_16f628.mpas,90 :: 		RCSTA.CREN := 1;    // enable receiving / accept continuous mode
	BSF        RCSTA+0, 4
;electronique_interface_midi_012_16f628.mpas,91 :: 		RCSTA.SPEN := 1;    // Rx enabled;
	BSF        RCSTA+0, 7
;electronique_interface_midi_012_16f628.mpas,92 :: 		RCSTA.RX9 := 0;     // 8-bits transmission
	BCF        RCSTA+0, 6
;electronique_interface_midi_012_16f628.mpas,93 :: 		PIE1.RCIE := 1;     // enable interrupt for UART Rx
	BSF        PIE1+0, 5
;electronique_interface_midi_012_16f628.mpas,95 :: 		UART1_Init(cMidiBaudrate); // speed for MIDI communication
	MOVLW      39
	MOVWF      SPBRG+0
	BSF        TXSTA+0, 2
	CALL       _UART1_Init+0
;electronique_interface_midi_012_16f628.mpas,97 :: 		Delay_ms(100);
	MOVLW      3
	MOVWF      R11+0
	MOVLW      138
	MOVWF      R12+0
	MOVLW      85
	MOVWF      R13+0
L__Main_Init1:
	DECFSZ     R13+0, 1
	GOTO       L__Main_Init1
	DECFSZ     R12+0, 1
	GOTO       L__Main_Init1
	DECFSZ     R11+0, 1
	GOTO       L__Main_Init1
	NOP
	NOP
;electronique_interface_midi_012_16f628.mpas,100 :: 		Memset(@ArrRxBuf, 0, cRxBufSize);
	MOVLW      _ArrRxBuf+0
	MOVWF      FARG_memset_p+0
	CLRF       FARG_memset_character+0
	MOVLW      64
	MOVWF      FARG_memset_n+0
	CLRF       FARG_memset_n+1
	CALL       _memset+0
;electronique_interface_midi_012_16f628.mpas,101 :: 		iRxHead     := 0;
	CLRF       _iRxHead+0
;electronique_interface_midi_012_16f628.mpas,102 :: 		iRxTail     := 0;
	CLRF       _iRxTail+0
;electronique_interface_midi_012_16f628.mpas,103 :: 		bRxBufFull  := false ;
	CLRF       _bRxBufFull+0
;electronique_interface_midi_012_16f628.mpas,104 :: 		bRxBufEmpty := true;
	MOVLW      255
	MOVWF      _bRxBufEmpty+0
;electronique_interface_midi_012_16f628.mpas,105 :: 		iCounter    := 0;
	CLRF       _iCounter+0
;electronique_interface_midi_012_16f628.mpas,108 :: 		iMTCCount := 0;
	CLRF       _iMTCCount+0
;electronique_interface_midi_012_16f628.mpas,109 :: 		iDivRate := 0;
	CLRF       _iDivRate+0
;electronique_interface_midi_012_16f628.mpas,110 :: 		iRxByteCount := 0;
	CLRF       _iRxByteCount+0
;electronique_interface_midi_012_16f628.mpas,111 :: 		Out_Pos := 0;
	BCF        RA0_bit+0, 0
;electronique_interface_midi_012_16f628.mpas,112 :: 		Out_Neg := 1;
	BSF        RA1_bit+0, 1
;electronique_interface_midi_012_16f628.mpas,113 :: 		Out_PosDivX := 0;
	BCF        RA2_bit+0, 2
;electronique_interface_midi_012_16f628.mpas,114 :: 		Out_NegDivX := 1;
	BSF        RA3_bit+0, 3
;electronique_interface_midi_012_16f628.mpas,116 :: 		end;
L_end_Main_Init:
	RETURN
; end of _Main_Init

_Interrupt:
	MOVWF      R15+0
	SWAPF      STATUS+0, 0
	CLRF       STATUS+0
	MOVWF      ___saveSTATUS+0
	MOVF       PCLATH+0, 0
	MOVWF      ___savePCLATH+0
	CLRF       PCLATH+0

;electronique_interface_midi_012_16f628.mpas,119 :: 		begin
;electronique_interface_midi_012_16f628.mpas,121 :: 		if PIR1.RCIF = 1 then
	BTFSS      PIR1+0, 5
	GOTO       L__Interrupt4
;electronique_interface_midi_012_16f628.mpas,123 :: 		iRxStatus := RCSTA; // Error-handling
	MOVF       RCSTA+0, 0
	MOVWF      _iRxStatus+0
;electronique_interface_midi_012_16f628.mpas,126 :: 		iRxData := RCREG;
	MOVF       RCREG+0, 0
	MOVWF      _iRxData+0
;electronique_interface_midi_012_16f628.mpas,130 :: 		if (iRxStatus and %00000110) = 0 then
	MOVLW      6
	ANDWF      _iRxStatus+0, 0
	MOVWF      R1+0
	MOVF       R1+0, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__Interrupt7
;electronique_interface_midi_012_16f628.mpas,132 :: 		if (not bRxBufFull) then       // if buffer full, do nothing
	COMF       _bRxBufFull+0, 0
	MOVWF      R0+0
	BTFSC      STATUS+0, 2
	GOTO       L__Interrupt10
;electronique_interface_midi_012_16f628.mpas,135 :: 		if (iRxData <> cMIDI_Active_Sensing) then
	MOVF       _iRxData+0, 0
	XORLW      254
	BTFSC      STATUS+0, 2
	GOTO       L__Interrupt13
;electronique_interface_midi_012_16f628.mpas,137 :: 		ArrRxBuf[iRxTail] := iRxData;
	MOVF       _iRxTail+0, 0
	ADDLW      _ArrRxBuf+0
	MOVWF      FSR
	MOVF       _iRxData+0, 0
	MOVWF      INDF+0
;electronique_interface_midi_012_16f628.mpas,138 :: 		Inc(iRxTail);
	INCF       _iRxTail+0, 1
;electronique_interface_midi_012_16f628.mpas,139 :: 		if iRxTail > cRxBufSize then // reach buffer end, return to buffer start
	MOVF       _iRxTail+0, 0
	SUBLW      64
	BTFSC      STATUS+0, 0
	GOTO       L__Interrupt16
;electronique_interface_midi_012_16f628.mpas,140 :: 		iRxTail := 0;
	CLRF       _iRxTail+0
L__Interrupt16:
;electronique_interface_midi_012_16f628.mpas,141 :: 		bRxBufEmpty := false;        // flag that some data have been received
	CLRF       _bRxBufEmpty+0
;electronique_interface_midi_012_16f628.mpas,142 :: 		if iRxTail = iRxHead then
	MOVF       _iRxTail+0, 0
	XORWF      _iRxHead+0, 0
	BTFSS      STATUS+0, 2
	GOTO       L__Interrupt19
;electronique_interface_midi_012_16f628.mpas,143 :: 		bRxBufFull := true;
	MOVLW      255
	MOVWF      _bRxBufFull+0
L__Interrupt19:
;electronique_interface_midi_012_16f628.mpas,144 :: 		end;
L__Interrupt13:
;electronique_interface_midi_012_16f628.mpas,145 :: 		end;
L__Interrupt10:
;electronique_interface_midi_012_16f628.mpas,146 :: 		end
	GOTO       L__Interrupt8
;electronique_interface_midi_012_16f628.mpas,147 :: 		else
L__Interrupt7:
;electronique_interface_midi_012_16f628.mpas,151 :: 		Clearbit(RCSTA, CREN);
	BCF        RCSTA+0, 4
;electronique_interface_midi_012_16f628.mpas,152 :: 		Setbit(RCSTA, CREN);
	BSF        RCSTA+0, 4
;electronique_interface_midi_012_16f628.mpas,153 :: 		end;
L__Interrupt8:
;electronique_interface_midi_012_16f628.mpas,154 :: 		end;
L__Interrupt4:
;electronique_interface_midi_012_16f628.mpas,155 :: 		end;
L_end_Interrupt:
L__Interrupt113:
	MOVF       ___savePCLATH+0, 0
	MOVWF      PCLATH+0
	SWAPF      ___saveSTATUS+0, 0
	MOVWF      STATUS+0
	SWAPF      R15+0, 1
	SWAPF      R15+0, 0
	RETFIE
; end of _Interrupt

_Midi_DataReceived:

;electronique_interface_midi_012_16f628.mpas,158 :: 		begin
;electronique_interface_midi_012_16f628.mpas,160 :: 		result := (not bRxBufEmpty);
	COMF       _bRxBufEmpty+0, 0
	MOVWF      R1+0
;electronique_interface_midi_012_16f628.mpas,162 :: 		end;
	MOVF       R1+0, 0
	MOVWF      R0+0
L_end_Midi_DataReceived:
	RETURN
; end of _Midi_DataReceived

_Midi_MsgReceived:

;electronique_interface_midi_012_16f628.mpas,165 :: 		begin
;electronique_interface_midi_012_16f628.mpas,170 :: 		(ArrRxData[1] = cMIDI_Sysex_MTC) and
	MOVF       _ArrRxData+0, 0
	XORLW      248
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
;electronique_interface_midi_012_16f628.mpas,171 :: 		(iRxByteCount = 1)
	MOVF       _iRxByteCount+0, 0
	XORLW      1
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R1+0
	MOVF       R1+0, 0
	ANDWF      R0+0, 0
	MOVWF      R4+0
;electronique_interface_midi_012_16f628.mpas,172 :: 		);
	MOVF       R4+0, 0
	MOVWF      _bMTC+0
;electronique_interface_midi_012_16f628.mpas,176 :: 		(ArrRxData[1] = cMIDI_RT_Start) and
	MOVF       _ArrRxData+0, 0
	XORLW      250
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
;electronique_interface_midi_012_16f628.mpas,177 :: 		(iRxByteCount = 1)
	MOVF       R1+0, 0
	ANDWF      R0+0, 0
	MOVWF      R3+0
;electronique_interface_midi_012_16f628.mpas,178 :: 		);
	MOVF       R3+0, 0
	MOVWF      _bRTStart+0
;electronique_interface_midi_012_16f628.mpas,182 :: 		(ArrRxData[1] = cMIDI_RT_Stop) and
	MOVF       _ArrRxData+0, 0
	XORLW      252
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
;electronique_interface_midi_012_16f628.mpas,183 :: 		(iRxByteCount = 1)
	MOVF       R1+0, 0
	ANDWF      R0+0, 0
	MOVWF      R2+0
;electronique_interface_midi_012_16f628.mpas,184 :: 		);
	MOVF       R2+0, 0
	MOVWF      _bRTStop+0
;electronique_interface_midi_012_16f628.mpas,188 :: 		(ArrRxData[1] = cMIDI_Sysex_Start) and
	MOVF       _ArrRxData+0, 0
	XORLW      240
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R1+0
;electronique_interface_midi_012_16f628.mpas,189 :: 		(ArrRxData[2] = $7D) and
	MOVF       _ArrRxData+1, 0
	XORLW      125
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
	MOVF       R0+0, 0
	ANDWF      R1+0, 1
;electronique_interface_midi_012_16f628.mpas,192 :: 		(ArrRxData[7] = cMIDI_Sysex_End) and
	MOVF       _ArrRxData+6, 0
	XORLW      247
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
	MOVF       R0+0, 0
	ANDWF      R1+0, 1
;electronique_interface_midi_012_16f628.mpas,193 :: 		(iRxByteCount = 7)
	MOVF       _iRxByteCount+0, 0
	XORLW      7
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
	MOVF       R0+0, 0
	ANDWF      R1+0, 1
;electronique_interface_midi_012_16f628.mpas,194 :: 		);
	MOVF       R1+0, 0
	MOVWF      _bSysex+0
;electronique_interface_midi_012_16f628.mpas,196 :: 		result := (bMTC or bRTStart or bRTStop or bSysex);
	MOVF       R3+0, 0
	IORWF      R4+0, 0
	MOVWF      R0+0
	MOVF       R2+0, 0
	IORWF      R0+0, 1
	MOVF       R1+0, 0
	IORWF      R0+0, 0
	MOVWF      R5+0
;electronique_interface_midi_012_16f628.mpas,198 :: 		end;
	MOVF       R5+0, 0
	MOVWF      R0+0
L_end_Midi_MsgReceived:
	RETURN
; end of _Midi_MsgReceived

_Midi_RxReadByte:

;electronique_interface_midi_012_16f628.mpas,204 :: 		begin
;electronique_interface_midi_012_16f628.mpas,206 :: 		Rk := 0;
	CLRF       Midi_RxReadByte_Rk+0
;electronique_interface_midi_012_16f628.mpas,208 :: 		if bRxBufEmpty = false then
	MOVF       _bRxBufEmpty+0, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__Midi_RxReadByte25
;electronique_interface_midi_012_16f628.mpas,211 :: 		Rk := ArrRxBuf[iRxHead];
	MOVF       _iRxHead+0, 0
	ADDLW      _ArrRxBuf+0
	MOVWF      FSR
	MOVF       INDF+0, 0
	MOVWF      Midi_RxReadByte_Rk+0
;electronique_interface_midi_012_16f628.mpas,214 :: 		if bRxEcho then
	MOVF       _bRxEcho+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L__Midi_RxReadByte28
;electronique_interface_midi_012_16f628.mpas,215 :: 		UART1_Write(Rk);
	MOVF       Midi_RxReadByte_Rk+0, 0
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
L__Midi_RxReadByte28:
;electronique_interface_midi_012_16f628.mpas,218 :: 		if ((Rk = cMIDI_Sysex_MTC) or (Rk = cMIDI_Sysex_Start)) then
	MOVF       Midi_RxReadByte_Rk+0, 0
	XORLW      248
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R1+0
	MOVF       Midi_RxReadByte_Rk+0, 0
	XORLW      240
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      R0+0
	MOVF       R1+0, 0
	IORWF      R0+0, 1
	BTFSC      STATUS+0, 2
	GOTO       L__Midi_RxReadByte31
;electronique_interface_midi_012_16f628.mpas,219 :: 		iRxByteCount := 1
	MOVLW      1
	MOVWF      _iRxByteCount+0
	GOTO       L__Midi_RxReadByte32
;electronique_interface_midi_012_16f628.mpas,220 :: 		else
L__Midi_RxReadByte31:
;electronique_interface_midi_012_16f628.mpas,221 :: 		inc(iRxByteCount);
	INCF       _iRxByteCount+0, 1
L__Midi_RxReadByte32:
;electronique_interface_midi_012_16f628.mpas,222 :: 		ArrRxData[iRxByteCount] := Rk;
	DECF       _iRxByteCount+0, 0
	MOVWF      R0+0
	MOVF       R0+0, 0
	ADDLW      _ArrRxData+0
	MOVWF      FSR
	MOVF       Midi_RxReadByte_Rk+0, 0
	MOVWF      INDF+0
;electronique_interface_midi_012_16f628.mpas,224 :: 		ArrRxBuf[iRxHead] := 0; // clear value that has been read (not really needed ?)
	MOVF       _iRxHead+0, 0
	ADDLW      _ArrRxBuf+0
	MOVWF      FSR
	CLRF       INDF+0
;electronique_interface_midi_012_16f628.mpas,225 :: 		inc(iRxHead);
	INCF       _iRxHead+0, 1
;electronique_interface_midi_012_16f628.mpas,226 :: 		if iRxHead > cRxBufSize then
	MOVF       _iRxHead+0, 0
	SUBLW      64
	BTFSC      STATUS+0, 0
	GOTO       L__Midi_RxReadByte34
;electronique_interface_midi_012_16f628.mpas,227 :: 		iRxHead := 0;
	CLRF       _iRxHead+0
L__Midi_RxReadByte34:
;electronique_interface_midi_012_16f628.mpas,228 :: 		bRxBufEmpty := (iRxHead = iRxTail); // all received bytes have been read
	MOVF       _iRxHead+0, 0
	XORWF      _iRxTail+0, 0
	MOVLW      255
	BTFSS      STATUS+0, 2
	MOVLW      0
	MOVWF      _bRxBufEmpty+0
;electronique_interface_midi_012_16f628.mpas,230 :: 		end;
L__Midi_RxReadByte25:
;electronique_interface_midi_012_16f628.mpas,231 :: 		Result := Rk;
	MOVF       Midi_RxReadByte_Rk+0, 0
	MOVWF      Midi_RxReadByte_local_result+0
;electronique_interface_midi_012_16f628.mpas,232 :: 		end;
	MOVF       Midi_RxReadByte_local_result+0, 0
	MOVWF      R0+0
L_end_Midi_RxReadByte:
	RETURN
; end of _Midi_RxReadByte

_Midi_TxNotePlay:

;electronique_interface_midi_012_16f628.mpas,235 :: 		begin
;electronique_interface_midi_012_16f628.mpas,236 :: 		UART1_Write(Data1);
	MOVF       FARG_Midi_TxNotePlay_Data1+0, 0
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;electronique_interface_midi_012_16f628.mpas,237 :: 		UART1_Write(Data2);
	MOVF       FARG_Midi_TxNotePlay_Data2+0, 0
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;electronique_interface_midi_012_16f628.mpas,238 :: 		UART1_Write(Data3);
	MOVF       FARG_Midi_TxNotePlay_Data3+0, 0
	MOVWF      FARG_UART1_Write_data_+0
	CALL       _UART1_Write+0
;electronique_interface_midi_012_16f628.mpas,239 :: 		end;
L_end_Midi_TxNotePlay:
	RETURN
; end of _Midi_TxNotePlay

_Rx_Reset:

;electronique_interface_midi_012_16f628.mpas,242 :: 		begin
;electronique_interface_midi_012_16f628.mpas,243 :: 		for i := 1 to 3 do
	MOVLW      1
	MOVWF      _i+0
L__Rx_Reset39:
;electronique_interface_midi_012_16f628.mpas,244 :: 		ArrRxData[i] := $00;
	DECF       _i+0, 0
	MOVWF      R0+0
	MOVF       R0+0, 0
	ADDLW      _ArrRxData+0
	MOVWF      FSR
	CLRF       INDF+0
	MOVF       _i+0, 0
	XORLW      3
	BTFSC      STATUS+0, 2
	GOTO       L__Rx_Reset42
	INCF       _i+0, 1
	GOTO       L__Rx_Reset39
L__Rx_Reset42:
;electronique_interface_midi_012_16f628.mpas,245 :: 		end;
L_end_Rx_Reset:
	RETURN
; end of _Rx_Reset

_UserPrefs_DivRateLoad:

;electronique_interface_midi_012_16f628.mpas,250 :: 		begin
;electronique_interface_midi_012_16f628.mpas,251 :: 		iDivCode := 0;
	CLRF       UserPrefs_DivRateLoad_iDivCode+0
;electronique_interface_midi_012_16f628.mpas,252 :: 		if In_Conf0 = 1 then iDivCode := iDivCode + 1;
	BTFSS      RB4_bit+0, 4
	GOTO       L__UserPrefs_DivRateLoad45
	INCF       UserPrefs_DivRateLoad_iDivCode+0, 1
L__UserPrefs_DivRateLoad45:
;electronique_interface_midi_012_16f628.mpas,253 :: 		if In_Conf1 = 1 then iDivCode := iDivCode + 2;
	BTFSS      RB5_bit+0, 5
	GOTO       L__UserPrefs_DivRateLoad48
	MOVLW      2
	ADDWF      UserPrefs_DivRateLoad_iDivCode+0, 1
L__UserPrefs_DivRateLoad48:
;electronique_interface_midi_012_16f628.mpas,254 :: 		if In_Conf2 = 1 then iDivCode := iDivCode + 4;
	BTFSS      RB6_bit+0, 6
	GOTO       L__UserPrefs_DivRateLoad51
	MOVLW      4
	ADDWF      UserPrefs_DivRateLoad_iDivCode+0, 1
L__UserPrefs_DivRateLoad51:
;electronique_interface_midi_012_16f628.mpas,256 :: 		0 : iDivRate := 1;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      0
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad56
	MOVLW      1
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad56:
;electronique_interface_midi_012_16f628.mpas,257 :: 		1 : iDivRate := 2;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      1
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad59
	MOVLW      2
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad59:
;electronique_interface_midi_012_16f628.mpas,258 :: 		2 : iDivRate := 4;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      2
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad62
	MOVLW      4
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad62:
;electronique_interface_midi_012_16f628.mpas,259 :: 		3 : iDivRate := 8;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      3
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad65
	MOVLW      8
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad65:
;electronique_interface_midi_012_16f628.mpas,260 :: 		4 : iDivRate := 16;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      4
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad68
	MOVLW      16
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad68:
;electronique_interface_midi_012_16f628.mpas,261 :: 		5 : iDivRate := 32;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      5
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad71
	MOVLW      32
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad71:
;electronique_interface_midi_012_16f628.mpas,262 :: 		6 : iDivRate := 64;
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      6
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad74
	MOVLW      64
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad74:
;electronique_interface_midi_012_16f628.mpas,263 :: 		7 : iDivRate := EEProm_Read(0);
	MOVF       UserPrefs_DivRateLoad_iDivCode+0, 0
	XORLW      7
	BTFSS      STATUS+0, 2
	GOTO       L__UserPrefs_DivRateLoad77
	CLRF       FARG_EEPROM_Read_address+0
	CALL       _EEPROM_Read+0
	MOVF       R0+0, 0
	MOVWF      _iDivRate+0
	GOTO       L__UserPrefs_DivRateLoad53
L__UserPrefs_DivRateLoad77:
L__UserPrefs_DivRateLoad53:
;electronique_interface_midi_012_16f628.mpas,265 :: 		end;
L_end_UserPrefs_DivRateLoad:
	RETURN
; end of _UserPrefs_DivRateLoad

_UserPrefs_DivRateSave:

;electronique_interface_midi_012_16f628.mpas,270 :: 		begin
;electronique_interface_midi_012_16f628.mpas,272 :: 		iDivRateTmp := ArrRxData[5] and %00001111;           // LSB
	MOVLW      15
	ANDWF      _ArrRxData+4, 0
	MOVWF      FARG_EEPROM_Write_data_+0
;electronique_interface_midi_012_16f628.mpas,273 :: 		iDivRateTmp := iDivRateTmp or (ArrRxData[6] SHL 4); // MSB
	MOVF       _ArrRxData+5, 0
	MOVWF      R0+0
	RLF        R0+0, 1
	BCF        R0+0, 0
	RLF        R0+0, 1
	BCF        R0+0, 0
	RLF        R0+0, 1
	BCF        R0+0, 0
	RLF        R0+0, 1
	BCF        R0+0, 0
	MOVF       R0+0, 0
	IORWF      FARG_EEPROM_Write_data_+0, 1
;electronique_interface_midi_012_16f628.mpas,274 :: 		EEProm_Write($00, iDivRateTmp);
	CLRF       FARG_EEPROM_Write_address+0
	CALL       _EEPROM_Write+0
;electronique_interface_midi_012_16f628.mpas,275 :: 		Delay_ms(10);
	MOVLW      65
	MOVWF      R12+0
	MOVLW      238
	MOVWF      R13+0
L__UserPrefs_DivRateSave79:
	DECFSZ     R13+0, 1
	GOTO       L__UserPrefs_DivRateSave79
	DECFSZ     R12+0, 1
	GOTO       L__UserPrefs_DivRateSave79
	NOP
;electronique_interface_midi_012_16f628.mpas,276 :: 		UserPrefs_DivRateLoad;  // reload with new value
	CALL       _UserPrefs_DivRateLoad+0
;electronique_interface_midi_012_16f628.mpas,277 :: 		end;
L_end_UserPrefs_DivRateSave:
	RETURN
; end of _UserPrefs_DivRateSave

_Main_Welcome:

;electronique_interface_midi_012_16f628.mpas,280 :: 		begin
;electronique_interface_midi_012_16f628.mpas,281 :: 		Out_Led := 0;
	BCF        RA4_bit+0, 4
;electronique_interface_midi_012_16f628.mpas,282 :: 		Delay_ms(250);
	MOVLW      7
	MOVWF      R11+0
	MOVLW      88
	MOVWF      R12+0
	MOVLW      89
	MOVWF      R13+0
L__Main_Welcome81:
	DECFSZ     R13+0, 1
	GOTO       L__Main_Welcome81
	DECFSZ     R12+0, 1
	GOTO       L__Main_Welcome81
	DECFSZ     R11+0, 1
	GOTO       L__Main_Welcome81
	NOP
	NOP
;electronique_interface_midi_012_16f628.mpas,283 :: 		Out_Led := 1;
	BSF        RA4_bit+0, 4
;electronique_interface_midi_012_16f628.mpas,284 :: 		Delay_ms(250);
	MOVLW      7
	MOVWF      R11+0
	MOVLW      88
	MOVWF      R12+0
	MOVLW      89
	MOVWF      R13+0
L__Main_Welcome82:
	DECFSZ     R13+0, 1
	GOTO       L__Main_Welcome82
	DECFSZ     R12+0, 1
	GOTO       L__Main_Welcome82
	DECFSZ     R11+0, 1
	GOTO       L__Main_Welcome82
	NOP
	NOP
;electronique_interface_midi_012_16f628.mpas,285 :: 		Out_Led := 0;
	BCF        RA4_bit+0, 4
;electronique_interface_midi_012_16f628.mpas,293 :: 		end;
L_end_Main_Welcome:
	RETURN
; end of _Main_Welcome

_Interrupt_Enable:

;electronique_interface_midi_012_16f628.mpas,296 :: 		begin
;electronique_interface_midi_012_16f628.mpas,297 :: 		INTCON.GIE := bState;       // |- enable interrupt
	BTFSC      FARG_Interrupt_Enable_bState+0, 0
	GOTO       L__Interrupt_Enable123
	BCF        INTCON+0, 7
	GOTO       L__Interrupt_Enable124
L__Interrupt_Enable123:
	BSF        INTCON+0, 7
L__Interrupt_Enable124:
;electronique_interface_midi_012_16f628.mpas,298 :: 		INTCON.PEIE := bState;      // |
	BTFSC      FARG_Interrupt_Enable_bState+0, 0
	GOTO       L__Interrupt_Enable125
	BCF        INTCON+0, 6
	GOTO       L__Interrupt_Enable126
L__Interrupt_Enable125:
	BSF        INTCON+0, 6
L__Interrupt_Enable126:
;electronique_interface_midi_012_16f628.mpas,299 :: 		end;
L_end_Interrupt_Enable:
	RETURN
; end of _Interrupt_Enable

_main:

;electronique_interface_midi_012_16f628.mpas,302 :: 		begin
;electronique_interface_midi_012_16f628.mpas,303 :: 		Main_Init;
	CALL       _Main_Init+0
;electronique_interface_midi_012_16f628.mpas,304 :: 		bRxEcho := false;
	CLRF       _bRxEcho+0
;electronique_interface_midi_012_16f628.mpas,307 :: 		Main_Welcome;
	CALL       _Main_Welcome+0
;electronique_interface_midi_012_16f628.mpas,310 :: 		UserPrefs_DivRateLoad;
	CALL       _UserPrefs_DivRateLoad+0
;electronique_interface_midi_012_16f628.mpas,311 :: 		Delay_ms(30);
	MOVLW      195
	MOVWF      R12+0
	MOVLW      205
	MOVWF      R13+0
L__main85:
	DECFSZ     R13+0, 1
	GOTO       L__main85
	DECFSZ     R12+0, 1
	GOTO       L__main85
;electronique_interface_midi_012_16f628.mpas,314 :: 		Rx_Reset;
	CALL       _Rx_Reset+0
;electronique_interface_midi_012_16f628.mpas,315 :: 		iRxByteCount := 0;
	CLRF       _iRxByteCount+0
;electronique_interface_midi_012_16f628.mpas,318 :: 		Interrupt_Enable(true);
	MOVLW      255
	MOVWF      FARG_Interrupt_Enable_bState+0
	CALL       _Interrupt_Enable+0
;electronique_interface_midi_012_16f628.mpas,320 :: 		while true do
L__main87:
;electronique_interface_midi_012_16f628.mpas,324 :: 		if Midi_DataReceived then
	CALL       _Midi_DataReceived+0
	MOVF       R0+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L__main92
;electronique_interface_midi_012_16f628.mpas,328 :: 		Midi_RxReadByte;
	CALL       _Midi_RxReadByte+0
;electronique_interface_midi_012_16f628.mpas,331 :: 		if Midi_MsgReceived then
	CALL       _Midi_MsgReceived+0
	MOVF       R0+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L__main95
;electronique_interface_midi_012_16f628.mpas,335 :: 		if bMTC then
	MOVF       _bMTC+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L__main98
;electronique_interface_midi_012_16f628.mpas,338 :: 		Out_Pos := 1;
	BSF        RA0_bit+0, 0
;electronique_interface_midi_012_16f628.mpas,339 :: 		Out_Neg := 0;
	BCF        RA1_bit+0, 1
;electronique_interface_midi_012_16f628.mpas,340 :: 		if iMTCCount < iDivRate then
	MOVF       _iDivRate+0, 0
	SUBWF      _iMTCCount+0, 0
	BTFSC      STATUS+0, 0
	GOTO       L__main101
;electronique_interface_midi_012_16f628.mpas,341 :: 		inc(iMTCCount)
	INCF       _iMTCCount+0, 1
	GOTO       L__main102
;electronique_interface_midi_012_16f628.mpas,342 :: 		else
L__main101:
;electronique_interface_midi_012_16f628.mpas,345 :: 		iMTCCount := 1;
	MOVLW      1
	MOVWF      _iMTCCount+0
;electronique_interface_midi_012_16f628.mpas,346 :: 		Out_PosDivX := 1;
	BSF        RA2_bit+0, 2
;electronique_interface_midi_012_16f628.mpas,347 :: 		Out_NegDivX := 0;
	BCF        RA3_bit+0, 3
;electronique_interface_midi_012_16f628.mpas,348 :: 		end;
L__main102:
;electronique_interface_midi_012_16f628.mpas,349 :: 		Delay_ms(4);
	MOVLW      26
	MOVWF      R12+0
	MOVLW      248
	MOVWF      R13+0
L__main103:
	DECFSZ     R13+0, 1
	GOTO       L__main103
	DECFSZ     R12+0, 1
	GOTO       L__main103
	NOP
;electronique_interface_midi_012_16f628.mpas,350 :: 		Out_Pos := 0;
	BCF        RA0_bit+0, 0
;electronique_interface_midi_012_16f628.mpas,351 :: 		Out_Neg := 1;
	BSF        RA1_bit+0, 1
;electronique_interface_midi_012_16f628.mpas,352 :: 		Out_PosDivX := 0;
	BCF        RA2_bit+0, 2
;electronique_interface_midi_012_16f628.mpas,353 :: 		Out_NegDivX := 1;
	BSF        RA3_bit+0, 3
;electronique_interface_midi_012_16f628.mpas,354 :: 		end;
L__main98:
;electronique_interface_midi_012_16f628.mpas,357 :: 		if bSysex then
	MOVF       _bSysex+0, 0
	BTFSC      STATUS+0, 2
	GOTO       L__main105
;electronique_interface_midi_012_16f628.mpas,360 :: 		Interrupt_Enable(false);
	CLRF       FARG_Interrupt_Enable_bState+0
	CALL       _Interrupt_Enable+0
;electronique_interface_midi_012_16f628.mpas,361 :: 		Out_Led := 0;
	BCF        RA4_bit+0, 4
;electronique_interface_midi_012_16f628.mpas,362 :: 		UserPrefs_DivRateSave;
	CALL       _UserPrefs_DivRateSave+0
;electronique_interface_midi_012_16f628.mpas,363 :: 		Delay_ms(50);
	MOVLW      2
	MOVWF      R11+0
	MOVLW      69
	MOVWF      R12+0
	MOVLW      169
	MOVWF      R13+0
L__main107:
	DECFSZ     R13+0, 1
	GOTO       L__main107
	DECFSZ     R12+0, 1
	GOTO       L__main107
	DECFSZ     R11+0, 1
	GOTO       L__main107
	NOP
	NOP
;electronique_interface_midi_012_16f628.mpas,364 :: 		Out_Led := 1;
	BSF        RA4_bit+0, 4
;electronique_interface_midi_012_16f628.mpas,365 :: 		Interrupt_Enable(true);
	MOVLW      255
	MOVWF      FARG_Interrupt_Enable_bState+0
	CALL       _Interrupt_Enable+0
;electronique_interface_midi_012_16f628.mpas,366 :: 		end;
L__main105:
;electronique_interface_midi_012_16f628.mpas,369 :: 		if (In_Conf3 and (bRTStart or bRTStop)) then
	MOVF       _bRTStop+0, 0
	IORWF      _bRTStart+0, 0
	MOVWF      R1+0
	CLRF       R0+0
	BTFSC      RB7_bit+0, 7
	INCF       R0+0, 1
	MOVF       R1+0, 0
	ANDWF      R0+0, 1
	BTFSC      STATUS+0, 2
	GOTO       L__main109
;electronique_interface_midi_012_16f628.mpas,371 :: 		iMTCCount := 1;
	MOVLW      1
	MOVWF      _iMTCCount+0
;electronique_interface_midi_012_16f628.mpas,372 :: 		Out_Pos := 0;
	BCF        RA0_bit+0, 0
;electronique_interface_midi_012_16f628.mpas,373 :: 		Out_Neg := 1;
	BSF        RA1_bit+0, 1
;electronique_interface_midi_012_16f628.mpas,374 :: 		Out_PosDivX := 0;
	BCF        RA2_bit+0, 2
;electronique_interface_midi_012_16f628.mpas,375 :: 		Out_NegDivX := 1;
	BSF        RA3_bit+0, 3
;electronique_interface_midi_012_16f628.mpas,376 :: 		end;
L__main109:
;electronique_interface_midi_012_16f628.mpas,378 :: 		end;
L__main95:
;electronique_interface_midi_012_16f628.mpas,379 :: 		end;
L__main92:
;electronique_interface_midi_012_16f628.mpas,381 :: 		end;
	GOTO       L__main87
;electronique_interface_midi_012_16f628.mpas,383 :: 		end.
L_end_main:
	GOTO       $+0
; end of _main
